/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.utils;

import cn.keking.config.ConfigConstants;
import cn.keking.model.FileAttribute;
import cn.keking.model.ReturnResponse;
import cn.keking.utils.FtpUtils;
import cn.keking.utils.KkFileUtils;
import cn.keking.utils.WebUtils;
import io.mola.galimatias.GalimatiasParseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DownloadUtils {
    private static final Logger logger = LoggerFactory.getLogger(DownloadUtils.class);
    private static final String fileDir = ConfigConstants.getFileDir();
    private static final String URL_PARAM_FTP_USERNAME = "ftp.username";
    private static final String URL_PARAM_FTP_PASSWORD = "ftp.password";
    private static final String URL_PARAM_FTP_CONTROL_ENCODING = "ftp.control.encoding";

    public static ReturnResponse<String> downLoad(FileAttribute fileAttribute, String fileName) {
        String urlStr = fileAttribute.getUrl();
        ReturnResponse response = new ReturnResponse(0, "\u4e0b\u8f7d\u6210\u529f!!!", (Object)"");
        String realPath = DownloadUtils.getRelFilePath((String)fileName, (FileAttribute)fileAttribute);
        try {
            URL url = WebUtils.normalizedURL((String)urlStr);
            if (KkFileUtils.isHttpUrl((URL)url)) {
                File realFile = new File(realPath);
                FileUtils.copyURLToFile((URL)url, (File)realFile);
            } else if (KkFileUtils.isFtpUrl((URL)url)) {
                String ftpUsername = WebUtils.getUrlParameterReg((String)fileAttribute.getUrl(), (String)"ftp.username");
                String ftpPassword = WebUtils.getUrlParameterReg((String)fileAttribute.getUrl(), (String)"ftp.password");
                String ftpControlEncoding = WebUtils.getUrlParameterReg((String)fileAttribute.getUrl(), (String)"ftp.control.encoding");
                FtpUtils.download((String)fileAttribute.getUrl(), (String)realPath, (String)ftpUsername, (String)ftpPassword, (String)ftpControlEncoding);
            } else {
                response.setCode(1);
                response.setMsg("url\u4e0d\u80fd\u8bc6\u522burl" + urlStr);
            }
            response.setContent((Object)realPath);
            response.setMsg(fileName);
            return response;
        }
        catch (GalimatiasParseException | IOException e) {
            logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0curl\uff1a{}", (Object)urlStr, (Object)e);
            response.setCode(1);
            response.setContent(null);
            if (e instanceof FileNotFoundException) {
                response.setMsg("\u6587\u4ef6\u4e0d\u5b58\u5728!!!");
            } else {
                response.setMsg(e.getMessage());
            }
            return response;
        }
    }

    private static String getRelFilePath(String fileName, FileAttribute fileAttribute) {
        String type = fileAttribute.getSuffix();
        if (null == fileName) {
            UUID uuid = UUID.randomUUID();
            fileName = uuid + "." + type;
        } else {
            fileName = fileName.replace(fileName.substring(fileName.lastIndexOf(".") + 1), type);
        }
        String realPath = fileDir + fileName;
        File dirFile = new File(fileDir);
        if (!dirFile.exists() && !dirFile.mkdirs()) {
            logger.error("\u521b\u5efa\u76ee\u5f55\u3010{}\u3011\u5931\u8d25,\u53ef\u80fd\u662f\u6743\u9650\u4e0d\u591f\uff0c\u8bf7\u68c0\u67e5", (Object)fileDir);
        }
        return realPath;
    }
}

