/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.utils;

import cpdetector.CharsetPrinter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KkFileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KkFileUtils.class);
    public static final String DEFAULT_FILE_ENCODING = "UTF-8";

    public static boolean isHttpUrl(URL url) {
        return url.getProtocol().toLowerCase().startsWith("file") || url.getProtocol().toLowerCase().startsWith("http");
    }

    public static boolean isFtpUrl(URL url) {
        return "ftp".equalsIgnoreCase(url.getProtocol());
    }

    public static boolean deleteFileByName(String fileName) {
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            if (file.delete()) {
                LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u6210\u529f\uff01");
                return true;
            }
            LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6" + fileName + "\u5931\u8d25\uff01");
            return false;
        }
        LOGGER.info("\u5220\u9664\u5355\u4e2a\u6587\u4ef6\u5931\u8d25\uff1a" + fileName + "\u4e0d\u5b58\u5728\uff01");
        return false;
    }

    public static String getFileEncode(String filePath) {
        return KkFileUtils.getFileEncode((File)new File(filePath));
    }

    public static String getFileEncode(File file) {
        CharsetPrinter cp = new CharsetPrinter();
        try {
            String encoding = cp.guessEncoding(file);
            LOGGER.info("\u68c0\u6d4b\u5230\u6587\u4ef6\u3010{}\u3011\u7f16\u7801: {}", (Object)file.getAbsolutePath(), (Object)encoding);
            return encoding;
        }
        catch (IOException e) {
            LOGGER.warn("\u6587\u4ef6\u7f16\u7801\u83b7\u53d6\u5931\u8d25\uff0c\u91c7\u7528\u9ed8\u8ba4\u7684\u7f16\u7801\u683c\u5f0f\uff1aUTF-8", (Throwable)e);
            return "UTF-8";
        }
    }

    public static String suffixFromFileName(String fileName) {
        return fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
    }

    public static void deleteFileByPath(String filePath) {
        File file = new File(filePath);
        if (file.exists() && !file.delete()) {
            LOGGER.warn("\u538b\u7f29\u5305\u6e90\u6587\u4ef6\u5220\u9664\u5931\u8d25:{}\uff01", (Object)filePath);
        }
    }

    public static boolean deleteDirectory(String dir) {
        File dirFile;
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        if (!(dirFile = new File(dir)).exists() || !dirFile.isDirectory()) {
            LOGGER.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff1a" + dir + "\u4e0d\u5b58\u5728\uff01");
            return false;
        }
        boolean flag = true;
        File[] files = dirFile.listFiles();
        for (int i = 0; i < Objects.requireNonNull(files).length && !(files[i].isFile() ? !(flag = KkFileUtils.deleteFileByName((String)files[i].getAbsolutePath())) : files[i].isDirectory() && !(flag = KkFileUtils.deleteDirectory((String)files[i].getAbsolutePath()))); ++i) {
        }
        if (!dirFile.delete() || !flag) {
            LOGGER.info("\u5220\u9664\u76ee\u5f55\u5931\u8d25\uff01");
            return false;
        }
        return true;
    }
}

