/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.web.controller;

import cn.keking.model.FileAttribute;
import cn.keking.service.FileHandlerService;
import cn.keking.service.FilePreview;
import cn.keking.service.FilePreviewFactory;
import cn.keking.service.cache.CacheService;
import cn.keking.service.impl.OtherFilePreviewImpl;
import cn.keking.utils.WebUtils;
import fr.opensagres.xdocreport.core.io.IOUtils;
import io.mola.galimatias.GalimatiasParseException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.io.NetUtil;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class OnlinePreviewController {
    public static final String BASE64_DECODE_ERROR_MSG = "Base64\u89e3\u7801\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4f60\u7684 %s \u662f\u5426\u91c7\u7528 Base64 + urlEncode \u53cc\u91cd\u7f16\u7801\u4e86\uff01";
    private final Logger logger = LoggerFactory.getLogger(OnlinePreviewController.class);
    private final FilePreviewFactory previewFactory;
    private final CacheService cacheService;
    private final FileHandlerService fileHandlerService;
    private final OtherFilePreviewImpl otherFilePreview;

    public OnlinePreviewController(FilePreviewFactory filePreviewFactory, FileHandlerService fileHandlerService, CacheService cacheService, OtherFilePreviewImpl otherFilePreview) {
        this.previewFactory = filePreviewFactory;
        this.fileHandlerService = fileHandlerService;
        this.cacheService = cacheService;
        this.otherFilePreview = otherFilePreview;
    }

    @RequestMapping(value={"/onlinePreview"})
    public String onlinePreview(String url, Model model, HttpServletRequest req) {
        String fileUrl;
        try {
            fileUrl = new String(Base64.decodeBase64((String)url), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            String errorMsg = String.format(BASE64_DECODE_ERROR_MSG, "url");
            return this.otherFilePreview.notSupportedFile(model, errorMsg);
        }
        FileAttribute fileAttribute = this.fileHandlerService.getFileAttribute(fileUrl, req);
        model.addAttribute("file", (Object)fileAttribute);
        FilePreview filePreview = this.previewFactory.get(fileAttribute);
        this.logger.info("\u9884\u89c8\u6587\u4ef6url\uff1a{}\uff0cpreviewType\uff1a{}", (Object)fileUrl, (Object)fileAttribute.getType());
        return filePreview.filePreviewHandle(fileUrl, model, fileAttribute);
    }

    @RequestMapping(value={"/picturesPreview"})
    public String picturesPreview(String urls, Model model, HttpServletRequest req) throws UnsupportedEncodingException {
        String fileUrls;
        try {
            fileUrls = new String(Base64.decodeBase64((String)urls));
        }
        catch (Exception ex) {
            String errorMsg = String.format(BASE64_DECODE_ERROR_MSG, "urls");
            return this.otherFilePreview.notSupportedFile(model, errorMsg);
        }
        this.logger.info("\u9884\u89c8\u6587\u4ef6url\uff1a{}\uff0curls\uff1a{}", (Object)fileUrls, (Object)urls);
        String[] images = fileUrls.split("\\|");
        List<String> imgUrls = Arrays.asList(images);
        model.addAttribute("imgUrls", imgUrls);
        String currentUrl = req.getParameter("currentUrl");
        if (StringUtils.hasText((String)currentUrl)) {
            String decodedCurrentUrl = new String(Base64.decodeBase64((String)currentUrl));
            model.addAttribute("currentUrl", (Object)decodedCurrentUrl);
        } else {
            model.addAttribute("currentUrl", (Object)imgUrls.get(0));
        }
        return "picture";
    }

    @RequestMapping(value={"/getCorsFile"}, method={RequestMethod.GET})
    public void getCorsFile(String urlPath, HttpServletResponse response) {
        this.logger.info("\u4e0b\u8f7d\u8de8\u57dfpdf\u6587\u4ef6url\uff1a{}", (Object)urlPath);
        try {
            URL url = WebUtils.normalizedURL((String)urlPath);
            byte[] bytes = NetUtil.downloadBytes((String)url.toString());
            IOUtils.write((byte[])bytes, (OutputStream)response.getOutputStream());
        }
        catch (GalimatiasParseException | IOException e) {
            this.logger.error("\u4e0b\u8f7d\u8de8\u57dfpdf\u6587\u4ef6\u5f02\u5e38\uff0curl\uff1a{}", (Object)urlPath, (Object)e);
        }
    }

    @RequestMapping(value={"/addTask"})
    @ResponseBody
    public String addQueueTask(String url) {
        this.logger.info("\u6dfb\u52a0\u8f6c\u7801\u961f\u5217url\uff1a{}", (Object)url);
        this.cacheService.addQueueTask(url);
        return "success";
    }
}

