/*
 * Decompiled with CFR 0.152.
 */
package cn.keking.web.filter;

import cn.keking.config.ConfigConstants;
import cn.keking.config.WatermarkConfigConstants;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AttributeSetFilter
implements Filter {
    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        this.setWatermarkAttribute(request);
        this.setFileAttribute(request);
        filterChain.doFilter(request, response);
    }

    private void setFileAttribute(ServletRequest request) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        request.setAttribute("pdfDownloadDisable", (Object)ConfigConstants.getPdfDownloadDisable());
        request.setAttribute("fileKey", (Object)httpRequest.getParameter("fileKey"));
        request.setAttribute("switchDisabled", (Object)ConfigConstants.getOfficePreviewSwitchDisabled());
        request.setAttribute("fileUploadDisable", (Object)ConfigConstants.getFileUploadDisable());
    }

    private void setWatermarkAttribute(ServletRequest request) {
        String watermarkTxt = request.getParameter("watermarkTxt");
        request.setAttribute("watermarkTxt", (Object)(watermarkTxt != null ? watermarkTxt : WatermarkConfigConstants.getWatermarkTxt()));
        request.setAttribute("watermarkXSpace", (Object)WatermarkConfigConstants.getWatermarkXSpace());
        request.setAttribute("watermarkYSpace", (Object)WatermarkConfigConstants.getWatermarkYSpace());
        request.setAttribute("watermarkFont", (Object)WatermarkConfigConstants.getWatermarkFont());
        request.setAttribute("watermarkFontsize", (Object)WatermarkConfigConstants.getWatermarkFontsize());
        request.setAttribute("watermarkColor", (Object)WatermarkConfigConstants.getWatermarkColor());
        request.setAttribute("watermarkAlpha", (Object)WatermarkConfigConstants.getWatermarkAlpha());
        request.setAttribute("watermarkWidth", (Object)WatermarkConfigConstants.getWatermarkWidth());
        request.setAttribute("watermarkHeight", (Object)WatermarkConfigConstants.getWatermarkHeight());
        request.setAttribute("watermarkAngle", (Object)WatermarkConfigConstants.getWatermarkAngle());
    }

    public void destroy() {
    }
}

